# 实践论  
## 论认识和实践的关系——知和行的关系  

（一九三七年七月）  
  
> 在中国共产党内，曾经有一部分教条主义的同志长期拒绝中国革命的经验，否认“马克思主义不是教条而是行动的指南”这个真理，而只生吞活剥马克思主义书籍中的只言片语，去吓唬人们。还有另一部分经验主义的同志长期拘守于自身的片断经验，不了解理论对于革命实践的重要性，看不见革命的全局，虽然也是辛苦地——但却是盲目地在工作。这两类同志的错误思想，特别是教条主义思想，曾经在一九三一年至一九三四年使得中国革命受了极大的损失，而教条主义者却是披着马克思主义的外衣迷惑了广大的同志。毛泽东的《实践论》，是为着用马克思主义的认识论观点去揭露党内的教条主义和经验主义——特别是教条主义这些主观主义的错误而写的。因为重点是揭露看轻实践的教条主义这种主观主义，故题为《实践论》。毛泽东曾以这篇论文的观点在延安的抗日军事政治大学作过讲演。   
  
　　马克思以前的唯物论，离开人的社会性，离开人的历史发展，去观察认识问题，因此不能了解认识对社会实践的依赖关系，即认识对生产和阶级斗争的依赖关系。   
　　首先，马克思主义者认为人类的生产活动是最基本的实践活动，是决定其他一切活动的东西。人的认识，主要地依赖于物质的生产活动，逐渐地了解自然的现象、自然的性质、自然的规律性、人和自然的关系；而且经过生产活动，也在各种不同程度上逐渐地认识了人和人的一定的相互关系。一切这些知识，离开生产活动是不能得到的。在没有阶级的社会中，每个人以社会一员的资格，同其他社会成员协力，结成一定的生产关系，从事生产活动，以解决人类物质生活问题。在各种阶级的社会中，各阶级的社会成员，则又以各种不同的方式，结成一定的生产关系，从事生产活动，以解决人类物质生活问题。这是人的认识发展的基本来源。   
　　人的社会实践，不限于生产活动一种形式，还有多种其他的形式，阶级斗争，政治生活，科学和艺术的活动，总之社会实际生活的一切领域都是社会的人所参加的。因此，人的认识，在物质生活以外，还从政治生活文化生活中（与物质生活密切联系），在各种不同程度上，知道人和人的各种关系。其中，尤以各种形式的阶级斗争，给予人的认识发展以深刻的影响。在阶级社会中，每一个人都在一定的阶级地位中生活，各种思想无不打上阶级的烙印。   
　　马克思主义者认为人类社会的生产活动，是一步又一步地由低级向高级发展，因此，人们的认识，不论对于自然界方面，对于社会方面，也都是一步又一步地由低级向高级发展，即由浅入深，由片面到更多的方面。在很长的历史时期内，大家对于社会的历史只能限于片面的了解，这一方面是由于剥削阶级的偏见经常歪曲社会的历史，另方面，则由于生产规模的狭小，限制了人们的眼界。人们能够对于社会历史的发展作全面的历史的了解，把对于社会的认识变成了科学，这只是到了伴随巨大生产力——大工业而出现近代无产阶级的时候，这就是马克思主义的科学。   
　　马克思主义者认为，只有人们的社会实践，才是人们对于外界认识的真理性的标准。实际的情形是这样的，只有在社会实践过程中（物质生产过程中，阶级斗争过程中，科学实验过程中），人们达到了思想中所预想的结果时，人们的认识才被证实了。人们要想得到工作的胜利即得到预想的结果，一定要使自己的思想合于客观外界的规律性，如果不合，就会在实践中失败。人们经过失败之后，也就从失败取得教训，改正自己的思想使之适合于外界的规律性，人们就能变失败为胜利，所谓“失败者成功之母”，“吃一堑长一智”，就是这个道理。辩证唯物论的认识论把实践提到第一的地位，认为人的认识一点也不能离开实践，排斥一切否认实践重要性、使认识离开实践的错误理论。列宁这样说过：“实践高于（理论的）认识，因为它不但有普遍性的品格，而且还有直接现实性的品格。”⑴马克思主义的哲学辩证唯物论有两个最显著的特点：一个是它的阶级性，公然申明辩证唯物论是为无产阶级服务的；再一个是它的实践性，强调理论对于实践的依赖关系，理论的基础是实践，又转过来为实践服务。判定认识或理论之是否真理，不是依主观上觉得如何而定，而是依客观上社会实践的结果如何而定。真理的标准只能是社会的实践。实践的观点是辩证唯物论的认识论之第一的和基本的观点⑵。   
　　然而人的认识究竟怎样从实践发生，而又服务于实践呢？这只要看一看认识的发展过程就会明了的。   
　　原来人在实践过程中，开始只是看到过程中各个事物的现象方面，看到各个事物的片面，看到各个事物之间的外部联系。例如有些外面的人们到延安来考察，头一二天，他们看到了延安的地形、街道、屋宇，接触了许多的人，参加了宴会、晚会和群众大会，听到了各种说话，看到了各种文件，这些就是事物的现象，事物的各个片面以及这些事物的外部联系。这叫做认识的感性阶段，就是感觉和印象的阶段。也就是延安这些各别的事物作用于考察团先生们的感官，引起了他们的感觉，在他们的脑子中生起了许多的印象，以及这些印象间的大概的外部的联系，这是认识的第一个阶段。在这个阶段中，人们还不能造成深刻的概念，作出合乎论理（即合乎逻辑）的结论。   
　　社会实践的继续，使人们在实践中引起感觉和印象的东西反复了多次，于是在人们的脑子里生起了一个认识过程中的突变（即飞跃），产生了概念。概念这种东西已经不是事物的现象，不是事物的各个片面，不是它们的外部联系，而是抓着了事物的本质，事物的全体，事物的内部联系了。概念同感觉，不但是数量上的差别，而且有了性质上的差别。循此继进，使用判断和推理的方法，就可产生出合乎论理的结论来。《三国演义》上所谓“眉头一皱计上心来”，我们普通说话所谓“让我想一想”，就是人在脑子中运用概念以作判断和推理的工夫。这是认识的第二个阶段。外来的考察团先生们在他们集合了各种材料，加上他们“想了一想”之后，他们就能够作出“共产党的抗日民族统一战线的政策是彻底的、诚恳的和真实的”这样一个判断了。在他们作出这个判断之后，如果他们对于团结救国也是真实的的话，那末他们就能够进一步作出这样的结论：“抗日民族统一战线是能够成功的。”这个概念、判断和推理的阶段，在人们对于一个事物的整个认识过程中是更重要的阶段，也就是理性认识的阶段。认识的真正任务在于经过感觉而到达于思维，到达于逐步了解客观事物的内部矛盾，了解它的规律性，了解这一过程和那一过程间的内部联系，即到达于论理的认识。重复地说，论理的认识所以和感性的认识不同，是因为感性的认识是属于事物之片面的、现象的、外部联系的东西，论理的认识则推进了一大步，到达了事物的全体的、本质的、内部联系的东西，到达了暴露周围世界的内在的矛盾，因而能在周围世界的总体上，在周围世界一切方面的内部联系上去把握周围世界的发展。   
　　这种基于实践的由浅入深的辩证唯物论的关于认识发展过程的理论，在马克思主义以前，是没有一个人这样解决过的。马克思主义的唯物论，第一次正确地解决了这个问题，唯物地而且辩证地指出了认识的深化的运动，指出了社会的人在他们的生产和阶级斗争的复杂的、经常反复的实践中，由感性认识到论理认识的推移的运动。列宁说过：“物质的抽象，自然规律的抽象，价值的抽象以及其他等等，一句话，一切科学的（正确的、郑重的、非瞎说的）抽象，都更深刻、更正确、更完全地反映着自然。”⑶马克思列宁主义认为：认识过程中两个阶段的特性，在低级阶段，认识表现为感性的，在高级阶段，认识表现为论理的，但任何阶段，都是统一的认识过程中的阶段。感性和理性二者的性质不同，但又不是互相分离的，它们在实践的基础上统一起来了。我们的实践证明：感觉到了的东西，我们不能立刻理解它，只有理解了的东西才更深刻地感觉它。感觉只解决现象问题，理论才解决本质问题。这些问题的解决，一点也不能离开实践。无论何人要认识什么事物，除了同那个事物接触，即生活于（实践于）那个事物的环境中，是没有法子解决的。不能在封建社会就预先认识资本主义社会的规律，因为资本主义还未出现，还无这种实践。马克思主义只能是资本主义社会的产物。马克思不能在自由资本主义时代就预先具体地认识帝国主义时代的某些特异的规律，因为帝国主义这个资本主义最后阶段还未到来，还无这种实践，只有列宁和斯大林才能担当此项任务。马克思、恩格斯、列宁、斯大林之所以能够作出他们的理论，除了他们的天才条件之外，主要地是他们亲自参加了当时的阶级斗争和科学实验的实践，没有这后一个条件，任何天才也是不能成功的。“秀才不出门，全知天下事”，在技术不发达的古代只是一句空话，在技术发达的现代虽然可以实现这句话，然而真正亲知的是天下实践着的人，那些人在他们的实践中间取得了“知”，经过文字和技术的传达而到达于“秀才”之手，秀才乃能间接地“知天下事”。如果要直接地认识某种或某些事物，便只有亲身参加于变革现实、变革某种或某些事物的实践的斗争中，才能触到那种或那些事物的现象，也只有在亲身参加变革现实的实践的斗争中，才能暴露那种或那些事物的本质而理解它们。这是任何人实际上走着的认识路程，不过有些人故意歪曲地说些反对的话罢了。世上最可笑的是那些“知识里手”⑷，有了道听途说的一知半解，便自封为“天下第一”，适足见其不自量而已。知识的问题是一个科学问题，来不得半点的虚伪和骄傲，决定地需要的倒是其反面——诚实和谦逊的态度。你要有知识，你就得参加变革现实的实践。你要知道梨子的滋味，你就得变革梨子，亲口吃一吃。你要知道原子的组织同性质，你就得实行物理学和化学的实验，变革原子的情况。你要知道革命的理论和方法，你就得参加革命。一切真知都是从直接经验发源的。但人不能事事直接经验，事实上多数的知识都是间接经验的东西，这就是一切古代的和外域的知识。这些知识在古人在外人是直接经验的东西，如果在古人外人直接经验时是符合于列宁所说的条件“科学的抽象”，是科学地反映了客观的事物，那末这些知识是可靠的，否则就是不可靠的。所以，一个人的知识，不外直接经验的和间接经验的两部分。而且在我为间接经验者，在人则仍为直接经验。因此，就知识的总体说来，无论何种知识都是不能离开直接经验的。任何知识的来源，在于人的肉体感官对客观外界的感觉，否认了这个感觉，否认了直接经验，否认亲自参加变革现实的实践，他就不是唯物论者。“知识里手”之所以可笑，原因就是在这个地方。中国人有一句老话：“不入虎穴，焉得虎子。”这句话对于人们的实践是真理，对于认识论也是真理。离开实践的认识是不可能的。   
　　为了明了基于变革现实的实践而产生的辩证唯物论的认识运动——认识的逐渐深化的运动，下面再举出几个具体的例子。   
　　无产阶级对于资本主义社会的认识，在其实践的初期——破坏机器和自发斗争时期，他们还只在感性认识的阶段，只认识资本主义各个现象的片面及其外部的联系。这时，他们还是一个所谓“自在的阶级”。但是到了他们实践的第二个时期——有意识有组织的经济斗争和政治斗争的时期，由于实践，由于长期斗争的经验，经过马克思、恩格斯用科学的方法把这种种经验总结起来，产生了马克思主义的理论，用以教育无产阶级，这样就使无产阶级理解了资本主义社会的本质，理解了社会阶级的剥削关系，理解了无产阶级的历史任务，这时他们就变成了一个“自为的阶级”。   
　　中国人民对于帝国主义的认识也是这样。第一阶段是表面的感性的认识阶段，表现在太平天国运动和义和团运动等笼统的排外主义的斗争上⑸。第二阶段才进到理性的认识阶段，看出了帝国主义内部和外部的各种矛盾，并看出了帝国主义联合中国买办阶级和封建阶级以压榨中国人民大众的实质，这种认识是从一九一九年五四运动⑹前后才开始的。   
　　我们再来看战争。战争的领导者，如果他们是一些没有战争经验的人，对于一个具体的战争（例如我们过去十年的土地革命战争）的深刻的指导规律，在开始阶段是不了解的。他们在开始阶段只是身历了许多作战的经验，而且败仗是打得很多的。然而由于这些经验（胜仗，特别是败仗的经验），使他们能够理解贯串整个战争的内部的东西，即那个具体战争的规律性，懂得了战略和战术，因而能够有把握地去指导战争。此时，如果改换一个无经验的人去指导，又会要在吃了一些败仗之后（有了经验之后）才能理会战争的正确的规律。   
　　常常听到一些同志在不能勇敢接受工作任务时说出来的一句话：没有把握。为什么没有把握呢？因为他对于这项工作的内容和环境没有规律性的了解，或者他从来就没有接触过这类工作，或者接触得不多，因而无从谈到这类工作的规律性。及至把工作的情况和环境给以详细分析之后，他就觉得比较地有了把握，愿意去做这项工作。如果这个人在这项工作中经过了一个时期，他有了这项工作的经验了，而他又是一个肯虚心体察情况的人，不是一个主观地、片面地、表面地看问题的人，他就能够自己做出应该怎样进行工作的结论，他的工作勇气也就可以大大地提高了。只有那些主观地、片面地和表面地看问题的人，跑到一个地方，不问环境的情况，不看事情的全体（事情的历史和全部现状），也不触到事情的本质（事情的性质及此一事情和其他事情的内部联系），就自以为是地发号施令起来，这样的人是没有不跌交子的。   
　　由此看来，认识的过程，第一步，是开始接触外界事情，属于感觉的阶段。第二步，是综合感觉的材料加以整理和改造，属于概念、判断和推理的阶段。只有感觉的材料十分丰富（不是零碎不全）和合于实际（不是错觉），才能根据这样的材料造出正确的概念和论理来。   
　　这里有两个要点必须着重指明。第一个，在前面已经说过的，这里再重复说一说，就是理性认识依赖于感性认识的问题。如果以为理性认识可以不从感性认识得来，他就是一个唯心论者。哲学史上有所谓“唯理论”一派，就是只承认理性的实在性，不承认经验的实在性，以为只有理性靠得住，而感觉的经验是靠不住的，这一派的错误在于颠倒了事实。理性的东西所以靠得住，正是由于它来源于感性，否则理性的东西就成了无源之水，无本之木，而只是主观自生的靠不住的东西了。从认识过程的秩序说来，感觉经验是第一的东西，我们强调社会实践在认识过程中的意义，就在于只有社会实践才能使人的认识开始发生，开始从客观外界得到感觉经验。一个闭目塞听、同客观外界根本绝缘的人，是无所谓认识的。认识开始于经验——这就是认识论的唯物论。   
　　第二是认识有待于深化，认识的感性阶段有待于发展到理性阶段——这就是认识论的辩证法⑺。如果以为认识可以停顿在低级的感性阶段，以为只有感性认识可靠，而理性认识是靠不住的，这便是重复了历史上的“经验论”的错误。这种理论的错误，在于不知道感觉材料固然是客观外界某些真实性的反映（我这里不来说经验只是所谓内省体验的那种唯心的经验论），但它们仅是片面的和表面的东西，这种反映是不完全的，是没有反映事物本质的。要完全地反映整个的事物，反映事物的本质，反映事物的内部规律性，就必须经过思考作用，将丰富的感觉材料加以去粗取精、去伪存真、由此及彼、由表及里的改造制作工夫，造成概念和理论的系统，就必须从感性认识跃进到理性认识。这种改造过的认识，不是更空虚了更不可靠了的认识，相反，只要是在认识过程中根据于实践基础而科学地改造过的东西，正如列宁所说乃是更深刻、更正确、更完全地反映客观事物的东西。庸俗的事务主义家不是这样，他们尊重经验而看轻理论，因而不能通观客观过程的全体，缺乏明确的方针，没有远大的前途，沾沾自喜于一得之功和一孔之见。这种人如果指导革命，就会引导革命走上碰壁的地步。   
　　理性认识依赖于感性认识，感性认识有待于发展到理性认识，这就是辩证唯物论的认识论。哲学上的“唯理论”和“经验论”都不懂得认识的历史性或辩证性，虽然各有片面的真理（对于唯物的唯理论和经验论而言，非指唯心的唯理论和经验论），但在认识论的全体上则都是错误的。由感性到理性之辩证唯物论的认识运动，对于一个小的认识过程（例如对于一个事物或一件工作的认识）是如此，对于一个大的认识过程（例如对于一个社会或一个革命的认识）也是如此。   
　　然而认识运动至此还没有完结。辩证唯物论的认识运动，如果只到理性认识为止，那末还只说到问题的一半。而且对于马克思主义的哲学说来，还只说到非十分重要的那一半。马克思主义的哲学认为十分重要的问题，不在于懂得了客观世界的规律性，因而能够解释世界，而在于拿了这种对于客观规律性的认识去能动地改造世界。在马克思主义看来，理论是重要的，它的重要性充分地表现在列宁说过的一句话：“没有革命的理论，就不会有革命的运动。”⑻然而马克思主义看重理论，正是，也仅仅是，因为它能够指导行动。如果有了正确的理论，只是把它空谈一阵，束之高阁，并不实行，那末，这种理论再好也是没有意义的。认识从实践始，经过实践得到了理论的认识，还须再回到实践去。认识的能动作用，不但表现于从感性的认识到理性的认识之能动的飞跃，更重要的还须表现于从理性的认识到革命的实践这一个飞跃。抓着了世界的规律性的认识，必须把它再回到改造世界的实践中去，再用到生产的实践、革命的阶级斗争和民族斗争的实践以及科学实验的实践中去。这就是检验理论和发展理论的过程，是整个认识过程的继续。理论的东西之是否符合于客观真理性这个问题，在前面说的由感性到理性之认识运动中是没有完全解决的，也不能完全解决的。要完全地解决这个问题，只有把理性的认识再回到社会实践中去，应用理论于实践，看它是否能够达到预想的目的。许多自然科学理论之所以被称为真理，不但在于自然科学家们创立这些学说的时候，而且在于为尔后的科学实践所证实的时候。马克思列宁主义之所以被称为真理，也不但在于马克思、恩格斯、列宁、斯大林等人科学地构成这些学说的时候，而且在于为尔后革命的阶级斗争和民族斗争的实践所证实的时候。辩证唯物论之所以为普遍真理，在于经过无论什么人的实践都不能逃出它的范围。人类认识的历史告诉我们，许多理论的真理性是不完全的，经过实践的检验而纠正了它们的不完全性。许多理论是错误的，经过实践的检验而纠正其错误。所谓实践是真理的标准，所谓“生活、实践底观点，应该是认识论底首先的和基本的观点”⑼，理由就在这个地方。斯大林说得好：“理论若不和革命实践联系起来，就会变成无对象的理论，同样，实践若不以革命理论为指南，就会变成盲目的实践。”⑽   
　　说到这里，认识运动就算完成了吗？我们的答复是完成了，又没有完成。社会的人们投身于变革在某一发展阶段内的某一客观过程的实践中（不论是关于变革某一自然过程的实践，或变革某一社会过程的实践），由于客观过程的反映和主观能动性的作用，使得人们的认识由感性的推移到了理性的，造成了大体上相应于该客观过程的法则性的思想、理论、计划或方案，然后再应用这种思想、理论、计划或方案于该同一客观过程的实践，如果能够实现预想的目的，即将预定的思想、理论、计划、方案在该同一过程的实践中变为事实，或者大体上变为事实，那末，对于这一具体过程的认识运动算是完成了。例如，在变革自然的过程中，某一工程计划的实现，某一科学假想的证实，某一器物的制成，某一农产的收获，在变革社会过程中某一罢工的胜利，某一战争的胜利，某一教育计划的实现，都算实现了预想的目的。然而一般地说来，不论在变革自然或变革社会的实践中，人们原定的思想、理论、计划、方案，毫无改变地实现出来的事，是很少的。这是因为从事变革现实的人们，常常受着许多的限制，不但常常受着科学条件和技术条件的限制，而且也受着客观过程的发展及其表现程度的限制（客观过程的方面及本质尚未充分暴露）。在这种情形之下，由于实践中发现前所未料的情况，因而部分地改变思想、理论、计划、方案的事是常有的，全部地改变的事也是有的。即是说，原定的思想、理论、计划、方案，部分地或全部地不合于实际，部分错了或全部错了的事，都是有的。许多时候须反复失败过多次，才能纠正错误的认识，才能到达于和客观过程的规律性相符合，因而才能够变主观的东西为客观的东西，即在实践中得到预想的结果。但是不管怎样，到了这种时候，人们对于在某一发展阶段内的某一客观过程的认识运动，算是完成了。   
　　然而对于过程的推移而言，人们的认识运动是没有完成的。任何过程，不论是属于自然界的和属于社会的，由于内部的矛盾和斗争，都是向前推移向前发展的，人们的认识运动也应跟着推移和发展。依社会运动来说，真正的革命的指导者，不但在于当自己的思想、理论、计划、方案有错误时须得善于改正，如同上面已经说到的，而且在于当某一客观过程已经从某一发展阶段向另一发展阶段推移转变的时候，须得善于使自己和参加革命的一切人员在主观认识上也跟着推移转变，即是要使新的革命任务和新的工作方案的提出，适合于新的情况的变化。革命时期情况的变化是很急速的，如果革命党人的认识不能随之而急速变化，就不能引导革命走向胜利。   
　　然而思想落后于实际的事是常有的，这是因为人的认识受了许多社会条件的限制的缘故。我们反对革命队伍中的顽固派，他们的思想不能随变化了的客观情况而前进，在历史上表现为右倾机会主义。这些人看不出矛盾的斗争已将客观过程推向前进了，而他们的认识仍然停止在旧阶段。一切顽固党的思想都有这样的特征。他们的思想离开了社会的实践，他们不能站在社会车轮的前头充任向导的工作，他们只知跟在车子后面怨恨车子走得太快了，企图把它向后拉，开倒车。   
　　我们也反对“左”翼空谈主义。他们的思想超过客观过程的一定发展阶段，有些把幻想看作真理，有些则把仅在将来有现实可能性的理想，勉强地放在现时来做，离开了当前大多数人的实践，离开了当前的现实性，在行动上表现为冒险主义。   
　　唯心论和机械唯物论，机会主义和冒险主义，都是以主观和客观相分裂，以认识和实践相脱离为特征的。以科学的社会实践为特征的马克思列宁主义的认识论，不能不坚决反对这些错误思想。马克思主义者承认，在绝对的总的宇宙发展过程中，各个具体过程的发展都是相对的，因而在绝对真理的长河中，人们对于在各个一定发展阶段上的具体过程的认识只具有相对的真理性。无数相对的真理之总和，就是绝对的真理⑾。客观过程的发展是充满着矛盾和斗争的发展，人的认识运动的发展也是充满着矛盾和斗争的发展。一切客观世界的辩证法的运动，都或先或后地能够反映到人的认识中来。社会实践中的发生、发展和消灭的过程是无穷的，人的认识的发生、发展和消灭的过程也是无穷的。根据于一定的思想、理论、计划、方案以从事于变革客观现实的实践，一次又一次地向前，人们对于客观现实的认识也就一次又一次地深化。客观现实世界的变化运动永远没有完结，人们在实践中对于真理的认识也就永远没有完结。马克思列宁主义并没有结束真理，而是在实践中不断地开辟认识真理的道路。我们的结论是主观和客观、理论和实践、知和行的具体的历史的统一，反对一切离开具体历史的“左”的或右的错误思想。   
　　社会的发展到了今天的时代，正确地认识世界和改造世界的责任，已经历史地落在无产阶级及其政党的肩上。这种根据科学认识而定下来的改造世界的实践过程，在世界、在中国均已到达了一个历史的时节——自有历史以来未曾有过的重大时节，这就是整个儿地推翻世界和中国的黑暗面，把它们转变过来成为前所未有的光明世界。无产阶级和革命人民改造世界的斗争，包括实现下述的任务：改造客观世界，也改造自己的主观世界——改造自己的认识能力，改造主观世界同客观世界的关系。地球上已经有一部分实行了这种改造，这就是苏联。他们还正在促进这种改造过程。中国人民和世界人民也都正在或将要通过这样的改造过程。所谓被改造的客观世界，其中包括了一切反对改造的人们，他们的被改造，须要通过强迫的阶段，然后才能进入自觉的阶段。世界到了全人类都自觉地改造自己和改造世界的时候，那就是世界的共产主义时代。   
　　通过实践而发现真理，又通过实践而证实真理和发展真理。从感性认识而能动地发展到理性认识，又从理性认识而能动地指导革命实践，改造主观世界和客观世界。实践、认识、再实践、再认识，这种形式，循环往复以至无穷，而实践和认识之每一循环的内容，都比较地进到了高一级的程度。这就是辩证唯物论的全部认识论，这就是辩证唯物论的知行统一观。   
  
  
------------------  
　　注　　释   
　　〔1〕见列宁《黑格尔〈逻辑学〉一书摘要》。新的译文是：“实践高于（理论的）认识，因为它不仅具有普遍性的品格，而且还具有直接现实性的品格。”（《列宁全集》第55卷，人民出版社1990年版，第183页）   
　　〔2〕参见马克思《关于费尔巴哈的提纲》（《马克思恩格斯选集》第1卷，人民出版社1972年版，第16—19页）和列宁《唯物主义和经验批判主义》第二章第六节（《列宁全集》第18卷，人民出版社1988年版，第144页）。   
　　〔3〕 见列宁《黑格尔〈逻辑学〉一书摘要》（《列宁全集》第55卷，人民出版社1990年版，第142页）。   
　　〔4〕里手，湖南方言，内行的意思。   
　　〔5〕一九五一年三月二十七日，毛泽东在致李达的信中说：“《实践论》中将太平天国放在排外主义一起说不妥，出选集时拟加修改，此处暂仍照原。”   
　　〔6〕五四运动是一九一九年五月四日发生的反帝反封建的爱国运动。当时，第一次世界大战刚刚结束，英、美、法、日、意等战胜国在巴黎召开对德和会，决定由日本继承德国在中国山东的特权。中国是参加对德宣战的战胜国之一，但北洋军阀政府却准备接受这个决定。五月四日，北京学生游行示威，反对帝国主义的这一无理决定和北洋军阀政府的妥协。这次运动迅速地获得了全国人民的响应，到六月三日以后，发展成为有工人阶级、城市小资产阶级和民族资产阶级参加的广大群众性的反帝反封建的爱国运动。五四运动也是反对封建文化的新文化运动。以一九一五年《青年杂志》（后改名《新青年》）创刊为起点的新文化运动，竖起“民主”和“科学”的旗帜，反对旧道德，提倡新道德，反对旧文学，提倡新文学。五四运动中的先进分子接受了马克思主义，使新文化运动发展成为马克思主义思想运动，他们致力于马克思主义同中国工人运动相结合，在思想上和干部上准备了中国共产党的成立。   
　　〔7〕参见列宁《黑格尔〈逻辑学〉一书摘要》：“要理解，就必须从经验开始理解、研究，从经验上升到一般。”（《列宁全集》第55卷，人民出版社1990年版，第175页）   
　　〔8〕见列宁《俄国社会民主党人的任务》（《列宁全集》第2卷，人民出版社1984年版，第443页）；并见列宁《怎么办？》第一章第四节（《列宁全集》第6卷，人民出版社1986年版，第23页）。   
　　〔9〕 见列宁《唯物主义和经验批判主义》第二章第六节（《列宁全集》第18卷，人民出版社1988年版，第144页）。   
　　〔10〕见斯大林《论列宁主义基础》第三部分《理论》。新的译文是：“离开革命实践的理论是空洞的理论，而不以革命理论为指南的实践是盲目的实践。”（《斯大林选集》上卷，人民出版社1979年版，第199—200页）   
　　〔11〕参见列宁《唯物主义和经验批判主义》第二章第五节。原文是：“人类思维按其本性是能够给我们提供并且正在提供由相对真理的总和所构成的绝对真理的。”（《列宁全集》第18卷，人民出版社1988年版，第135页）   